SET NOCOUNT ON
IF NOT EXISTS(
	SELECT 
		ID 
	FROM 
		SYSOBJECTS 
	WHERE 
		NAME = 'TELE_ORC_ETAPA' AND XTYPE = 'U')
BEGIN
	SET NOCOUNT OFF
	RAISERROR('A TABELA NA QUAL O INDEX SER ADICIONADO NO FOI ENCONTRADA NO BANCO DE DADOS.',16,1)
END

ELSE
BEGIN
	IF NOT EXISTS (
		SELECT
			* 
		FROM 
			SYS.INDEXES 
		WHERE 
			NAME = 'IX_TELE_ORC_ETAPA_CD_USU'
			AND OBJECT_ID IN (
				SELECT 
					ID 
				FROM 
					SYSOBJECTS 
				WHERE 
					NAME = 'TELE_ORC_ETAPA' AND XTYPE = 'U'))

		BEGIN
			CREATE NONCLUSTERED INDEX [IX_TELE_ORC_ETAPA_CD_USU] ON [dbo].[TELE_ORC_ETAPA] 
			(
				[CD_USU] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = OFF) ON [PRIMARY]

		END
	SET NOCOUNT OFF
	PRINT 'INDEX IX_TELE_ORC_ETAPA_CD_USU NA TABELA TELE_ORC_ETAPA INSERIDO COM SUCESSO '
END
